package demo;

import java.io.*;
import java.util.*;
import javax.microedition.io.*;
import de.kxml.*;
import de.kxml.kdom.*;
import de.kxml.parser.*;
import demo.data.*;

/**
 * Excute les services XML en utilisant kXML
 */
class XMLServices {
  // Instance de Singleton
  private static XMLServices instance;

  // Constructeur crant le contrle
  protected XMLServices() {
  }

  /**
   * Rcupre l'instance singleton
   */
  public static XMLServices getInstance() {
    if (instance == null) return new XMLServices();
    return instance;
  }

  // Services XML

  /**
   * Convertit un document XML en objets Info
   */
  public Info deserializeInfo(Document document) {
    Info info = null;
    Element root = document.getRootElement();
    String type = null;
    String titre = null;
    String contenu = null;
    int elemCount = root.getChildCount();
    for (int i = 0; i < elemCount; i++) {
      if (root.getType(i) == Xml.ELEMENT) {
        Element infoField = (Element) root.getChild(i);
        if (infoField.getName().equals("Type")) {
          type = (String) infoField.getChild(0);
        } else if (infoField.getName().equals("Titre")) {
          titre = (String) infoField.getChild(0);
        } else if (infoField.getName().equals("Contenu")) {
          contenu = (String) infoField.getChild(0);
        }
      }
    }
    info = new Info(type, titre, contenu);
    return info;
  }

  /**
   * Convertit un document XML en un vecteur d'objets InfoLink
   */
  public Vector deserializeInfoLinks(Document document) {
    Vector infoLinks = new Vector();
    Element root = document.getRootElement();
    int infoCount = root.getChildCount();
    for (int i = 0; i < infoCount; i++) {
      if (root.getType(i) == Xml.ELEMENT) {
        String name = null;
        String oid = null;
        Element infoLink = (Element) root.getChild(i);
        if (infoLink.getName().equals("InfoLink")) {
          int elemCount = infoLink.getChildCount();
          name = (String) infoLink.getChild(0);
          oid = parseOid(infoLink.getAttribute("href").getValue());
          infoLinks.addElement(new InfoLink(name, oid));
        }
      }
    }
    return infoLinks;
  }

  // Analyse le oid de la valeur de l'attribut href
  // Le format est : Details.po?id=<oid>
  private String parseOid(String href) {
    int equals = href.indexOf("=");
    return href.substring((equals + 1), href.length());
  }
}
